#!/bin/bash


# check arguments
packagename=levmar

# check function for return codes
function check
{
        # 1 is the failing command's name
        if test $? != 0; then
                echo "$1 failed wih error code $?"
                exit $?
        fi
}

# create distribution archive
tar --exclude='*build64*' --exclude='*.git*' -zcvf levmar_2.6.orig.tar.gz levmar-2.6
check tar

# find version
version=`ls ${packagename}_*.tar.gz | sort | tail -n 1 | sed -e "s#${packagename}_\(.*\).orig.tar.gz#\1#"`
check find_version
echo "Creating debian package of $packagename for version $version"

# extract
test ! -e ${packagename}-${version}_orig || { echo "${packagename}-${version}_orig must not be present."; exit 255; }
mv ${packagename}-${version} ${packagename}-${version}_orig
tar -zxf ${packagename}_${version}.orig.tar.gz
check extract_archive

# enter and build
cd ${packagename}-${version}
debuild -us -uc
check debuild

# and exit
exit 0
