/*
 * QtMainWindow.hpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

#ifndef QTMAINWINDOW_HPP_
#define QTMAINWINDOW_HPP_

#include "UIElements/MainWindow.hpp"
#include <QtGui/QMainWindow>

#include <map>
#include <set>

class QtWorldView;
class StringView;
class QtMenu;
class GLMoleculeView;
class QtMoleculeView;
class QtStatusBar;

class QtMainWindow : public QMainWindow, public MainWindow
{
  Q_OBJECT

public:
  QtMainWindow(QApplication *_theApp);
  virtual ~QtMainWindow();

  virtual void display();


private:
  typedef std::map <std::string, QtMenu *> QtMenuReferenceMap;
  typedef std::map <std::string, char> MenuShortcutMap;

  void populateMenu(QtMenuReferenceMap &NametoTextMenuMap, MenuShortcutMap &ShortcutMap);
  void populateMenuWithActions(QtMenuReferenceMap &NametoTextMenuMap, MenuShortcutMap &ShortcutMap);
  std::string getNameWithAccelerator(MenuShortcutMap &ShortcutMap, const std::string &MenuName, const std::string &ActionName) const;

  // All kinds of QTStuff used in this window
  QApplication *theApp;
  QtWorldView *worldDisplay;
  GLMoleculeView *molecule3dDisplay;
  QtMoleculeView *moleculeDisplay;
  QtStatusBar *statusBar;
  QMenuBar *MenuBar;

};

#endif /* QTMAINWINDOW_HPP_ */
