/*
 * MenuDescription.hpp
 *
 *  Created on: Oct 26, 2010
 *      Author: heber
 */

#ifndef MENUDESCRIPTION_HPP_
#define MENUDESCRIPTION_HPP_

#include <map>
#include <set>
#include <string>

class MenuDescriptionTest;

/** Class contains information on menus.
 *
 */
class MenuDescription
{
  friend class MenuDescriptionTest;
public:
  MenuDescription();
  ~MenuDescription();

  typedef std::pair<std::string, int> TopPosition;
  typedef std::map<std::string, TopPosition> IterableMap;
  typedef IterableMap::iterator iterator;
  typedef IterableMap::const_iterator const_iterator ;
  typedef std::map<std::string, std::string> TextMap;

  // getter for description
  const std::string getDescription(std::string token) const;
  const std::string getName(std::string token) const;

  std::multimap <std::string, std::string> getMenuItemsMap() const;

  // iterators
  iterator getBeginIter();
  iterator getEndIter();
  const_iterator getBeginIter() const;
  const_iterator getEndIter() const;

private:
  TextMap MenuDescriptionsMap;
  IterableMap MenuPositionMap;
  TextMap MenuNameMap;
  std::multimap <std::string, std::string> MenuItemMap;
};

#endif /* MENUDESCRIPTION_HPP_ */
