/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * OrthogonalSummationUnitTest.cpp
 *
 *  Created on: Jun 26, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "OrthogonalSummationUnitTest.hpp"

#include "Fragmentation/Summation/OrthogonalSummation.hpp"
#include "Fragmentation/Summation/SetValue.hpp"

#include <algorithm>
#include <boost/assign.hpp>

#include "CodePatterns/Log.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

using namespace boost::assign;

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( OrthogonalSummationTest );

void OrthogonalSummationTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);

  setVerbosity(5);

  // create a tree of sets
  IndexSet::ptr AllIndices(new IndexSet);
  (*AllIndices) += 1,2,3,4;
  CPPUNIT_ASSERT_EQUAL( (size_t)4, AllIndices->size() );
  container.reset(new IndexSetContainer(AllIndices));
  CPPUNIT_ASSERT_EQUAL( (size_t)1, container->getContainer().size() );
  IndexSet tempset;
  tempset += 1;
  container->insert(tempset);
  tempset += 2;
  container->insert(tempset);
  tempset.clear();
  tempset += 3;
  container->insert(tempset);
  tempset += 2;
  container->insert(tempset);
  CPPUNIT_ASSERT_EQUAL( (size_t)5, container->getContainer().size() );
  subsetmap.reset(new SubsetMap(*container));
}


void OrthogonalSummationTest::tearDown()
{
}

/** UnitTest for operator()
 */
void OrthogonalSummationTest::operator_staticTest()
{
  const IndexSetContainer::Container_t &_container = container->getContainer();
  for (int value = -5; value <= 5; ++value) {
    // create a value for each set (and copy indices to overcome constness in container)
    OrthogonalSummation<int>::InputSets_t indices(_container.begin(), _container.end());
    OrthogonalSummation<int>::InputValues_t values(_container.size(), value);
    // create the summation functor
    OrthogonalSummation<int> OS(indices, values, subsetmap);

    // sum up, as full set is contained we must get value again
    //CPPUNIT_ASSERT_EQUAL( 0, OS(0) ); /* zero value is not guaranteed to bet set to zero. */
    CPPUNIT_ASSERT_EQUAL( value*2, OS(1) );
    CPPUNIT_ASSERT_EQUAL( value*2, OS(2) );
    CPPUNIT_ASSERT_EQUAL( value*2, OS(3) );
    CPPUNIT_ASSERT_EQUAL( value, OS(4) );
    CPPUNIT_ASSERT_EQUAL( value, OS(5) );
  }
}
