/*
 * Summation.hpp
 *
 *  Created on: Jun 30, 2012
 *      Author: heber
 */

#ifndef SUMMATION_HPP_
#define SUMMATION_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>

#include "SetValue.hpp"
#include "SubsetMap.hpp"
#include "SetValueMap.hpp"

/** Summation is a functor executing a simple summation of SetValue's
 * that are each associated to a certain IndexSet whose union is a SetOfIndexSets.
 *
 * This is kept in signature alike to OrthogonalSummation.
 *
 *  For the given class we require the following functions:
 *  -# operator=(): assignment operator for placement in vector
 *  -# operator+=(): addition operator for adding one instance from another
 *  -# operator-=(): subtraction operator for subtracting one instance from another
 *  -# operator<<(): output operator
 */
template <class T>
class Summation
{
public:
  typedef std::vector< IndexSet::ptr > InputSets_t;
  typedef std::vector< T > InputValues_t;
  Summation(InputSets_t &indices, InputValues_t& values, SubsetMap::ptr _subsetmap = SubsetMap::ptr());

  /** Performs the summation and returns result.
   *
   * @param level sum up to this level
   * @return resulting value
   */
  T operator()(const size_t level) const;

private:
  T Sum(const size_t level) const;

private:
  //!> SubsetTree with the tree-like structure of subsets
  SubsetMap::ptr subsetmap;
  //!> set of all subset values
  SetValueMap<T> setvalues;
};

#include "Summation_impl.hpp"

#endif /* SUMMATION_HPP_ */
