/*
 * TextStatusIndicator.cpp
 *
 *  Created on: Feb 18, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "TextUI/TextStatusIndicator.hpp"

#include <iostream>

#include "Actions/Process.hpp"

using namespace std;

TextStatusIndicator::TextStatusIndicator() :
  Observer("TextStatusIndicator")
{
  Process::AddObserver(this);
}

TextStatusIndicator::~TextStatusIndicator()
{
  Process::RemoveObserver(this);
}

void TextStatusIndicator::update(Observable *subject){
  Process *proc;
  // we are only observing Processes
  if((proc=dynamic_cast<Process*>(subject))){
    // see what kind of progress we have to display
    if(proc->getMaxSteps()>0){
      if(!proc->doesStop()){
        cout << "Busy (" << proc->getName() << ") ";
        // we can show a percentage done
        cout << (int)proc->getDoneRatio() << "% done" << endl;
      }
    }
    else{
      // we only show some kind of busy animation
      if(proc->doesStart()){
        cout << "Busy (" << proc->getName() << ")";
      }
      if(!proc->doesStop()){
        cout << ".";
      }
      else {
        cout << endl;
      }
    }
  }
}

void TextStatusIndicator::subjectKilled(Observable *subject){

}

