/*
 * Fragmentation.hpp
 *
 *  Created on: Oct 18, 2011
 *      Author: heber
 */

#ifndef FRAGMENTATION_HPP_
#define FRAGMENTATION_HPP_


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Fragmentation/fragmentation_helpers.hpp"
#include "Fragmentation/Graph.hpp"
#include "Fragmentation/HydrogenSaturation_enum.hpp"
#include "Graph/ListOfLocalAtoms.hpp"
#include "types.hpp"

#include <map>
#include <string>
#include <vector>

#include <boost/bimap.hpp>

class atom;
class AtomMask_t;
class AdjacencyList;
class KeySet;
class molecule;

class Fragmentation
{
  // some typedefs for intermediat global id <-> local id bimap
  typedef atomId_t global_t;
  typedef atomId_t local_t;
  typedef boost::bimap< global_t, local_t > Global_local_bimap_t;
  typedef Global_local_bimap_t::value_type idpair_t;
public:
  Fragmentation(
      molecule *_mol,
      AdjacencyList &_FileChecker,
      const enum HydrogenTreatment _treatment);
  ~Fragmentation();

  int FragmentMolecule(const std::vector<atomId_t> &atomids, int Order, const std::string &prefix, const Graph &ParsedFragmentList);

  const Graph& getGraph() const {
    return TotalGraph;
  }

private:

  void FragmentBOSSANOVA(molecule *mol, Graph &FragmentList, KeyStack &RootStack);
  int GuesstimateFragmentCount(int order);

  // order at site
  bool CheckOrderAtSite(AtomMask_t &AtomMask, const Graph &GlobalKeySetList, int Order, const std::string &path, bool LoopDoneAlready);
  bool StoreOrderAtSiteFile(const std::string &path);
  bool ParseOrderAtSiteFromFile(const std::vector<atomId_t> &atomids, const std::string &path, const Global_local_bimap_t &global_local_bimap);

  // storing fragments
  void FillRootStackForSubgraphs(KeyStack &RootStack, const AtomMask_t &AtomMask);
  bool AssignKeySetsToFragment(const Graph &KeySetList, ListOfLocalAtoms_t &ListOfLocalAtoms, Graph &FragmentList, bool FreeList = false);
  void TranslateIndicesToGlobalIDs(Graph &FragmentList, int &TotalNumberOfKeySets, Graph &TotalGraph);

private:
  //!> pointer to molecule that is fragmented
  molecule *mol;
  //!> whether to treat hydrogen special
  const enum HydrogenTreatment treatment;
  //!> reference to an external adjacency for comparison
  AdjacencyList &FileChecker;
  //!> Resulting Graph with all keysets
  Graph TotalGraph;
};


#endif /* FRAGMENTATION_HPP_ */
