/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * RandomNumberValidators.cpp
 *
 *  Created on: May 14, 2012
 *      Author: ankele
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "RandomNumberValidators.hpp"

#include "RandomNumbers/RandomNumberDistributionFactory.hpp"
#include "RandomNumbers/RandomNumberEngineFactory.hpp"

RandomNumberDistributionNameValidator::RandomNumberDistributionNameValidator() :
  DiscreteValidator<std::string>(std::vector<std::string>())
{}

bool RandomNumberDistributionNameValidator::isValid(const std::string & _value) const
{
  RandomNumberDistributionFactory::getInstance();
  for (RandomNumberDistributionFactory::NameMap::const_iterator
      iter = RandomNumberDistributionFactory::getInstance().names.begin();
      iter != RandomNumberDistributionFactory::getInstance().names.end();
      ++iter) {
    if (_value == iter->second)
      return true;
  }
  return false;
}

const std::vector<std::string> &RandomNumberDistributionNameValidator::getValidValues() const
{
  currentList.clear();
  RandomNumberDistributionFactory::getInstance();
  for (RandomNumberDistributionFactory::NameMap::const_iterator
      iter = RandomNumberDistributionFactory::getInstance().names.begin();
      iter != RandomNumberDistributionFactory::getInstance().names.end();
      ++iter)
    currentList.push_back(iter->second);
  return currentList;
}

bool RandomNumberDistributionNameValidator::operator==(const Validator<std::string> &_instance) const
{
  const RandomNumberDistributionNameValidator *inst =
      dynamic_cast<const RandomNumberDistributionNameValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< std::string >* RandomNumberDistributionNameValidator::clone() const
{
  Validator< std::string > *inst =
      new RandomNumberDistributionNameValidator();
  return inst;
}









RandomNumberEngineNameValidator::RandomNumberEngineNameValidator() :
  DiscreteValidator<std::string>(std::vector<std::string>())
{}

bool RandomNumberEngineNameValidator::isValid(const std::string & _value) const
{
  RandomNumberEngineFactory::getInstance();
  for (RandomNumberEngineFactory::NameMap::const_iterator
      iter = RandomNumberEngineFactory::getInstance().names.begin();
      iter != RandomNumberEngineFactory::getInstance().names.end();
      ++iter) {
    if (iter->second == _value)
      return true;
  }
  return false;
}

const std::vector<std::string> &RandomNumberEngineNameValidator::getValidValues() const
{
  currentList.clear();
  RandomNumberEngineFactory::getInstance();
  for (RandomNumberEngineFactory::NameMap::const_iterator
      iter = RandomNumberEngineFactory::getInstance().names.begin();
      iter != RandomNumberEngineFactory::getInstance().names.end();
      ++iter)
    currentList.push_back(iter->second);
  return currentList;
}

bool RandomNumberEngineNameValidator::operator==(const Validator<std::string> &_instance) const
{
  const RandomNumberEngineNameValidator *inst =
      dynamic_cast<const RandomNumberEngineNameValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< std::string >* RandomNumberEngineNameValidator::clone() const
{
  Validator< std::string > *inst =
      new RandomNumberEngineNameValidator();
  return inst;
}




