/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the COPYING file or "Copyright notice" in builder.cpp for details.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>. 
 */

/*
 * FragmentMock.cpp
 *
 *  Created on: Dec 20, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include headers that implement a archive in simple text format
// otherwise BOOST_CLASS_EXPORT_IMPLEMENT has no effect
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "CodePatterns/MemDebug.hpp"

#include "Fragmentation/Summation/SetValues/Fragment.hpp"

#include <iostream>
#include <vector>

/** Default constructor of class Fragment.
 *
 */
Fragment::Fragment() {}

/** Constructor of class Fragment.
 *
 * @param _positions given positions
 * @param _charges given charges
 */
Fragment::Fragment(const positions_t &_positions, const charges_t &_charges)
{}

/** Adding another fragment onto this one.
 *
 * \note The operation is area-conserving, i.e. the new area is the sum of
 * both areas.
 *
 * @param other other fragment
 * @return ref to this instance
 */
Fragment& Fragment::operator+=(const Fragment &other)
  { return *this; }

/** Assignment operator.
 *
 * @param other other fragment to make ourselves equal to
 * @return ref to this instance
 */
Fragment& Fragment::operator=(const Fragment &other)
{ return *this; }

/** Subtracting another fragment from this one.
 *
 * @param other other fragment
 * @return ref to this instance
 */
Fragment& Fragment::operator-=(const Fragment &other)
{ return *this; }

/** Getter for all stored positions.
 *
 * @return vector of positions
 */
Fragment::positions_t Fragment::getPositions() const
{ return positions_t(); }

/** Getter for all stored charges.
 *
 * @return vector of charges
 */
Fragment::charges_t Fragment::getCharges() const
{ return charges_t(); }

/** Equality operator.
 *
 * @param other other instance to check against
 * @return true - both are equal, false - some nucleus_t differ
 */
bool Fragment::operator==(const Fragment& other) const
{ return true; }

/** Creates type nucleus_t from given \a position and \a charge.
 *
 * @param position position of nucleus to create
 * @param charge charge of nucleus to create
 * @return nucleus with given \a position and \a charge
 */
//  static nucleus_t Fragment::createNucleus(const position_t &position, const double charge);

/** Helper function to check whether two positions are equal.
 *
 * @param a first position
 * @param b second position
 * @return a equals b within numerical precision
 */
//  static bool Fragment::isPositionEqual(const position_t &a, const position_t &b);

// we need to explicitly instantiate the serialization functions
BOOST_CLASS_EXPORT_IMPLEMENT(Fragment)

/** Equality operator for two nuclei.
 *
 * @param a first nuclei
 * @param b second nuclei
 * @return true - both have same position and charge, false - either charge or position is different
 */
bool operator==(const Fragment::nucleus_t &a, const Fragment::nucleus_t &b)
{ return true; }

std::ostream & operator<<(std::ostream &ost, const Fragment::nucleus_t &n)
{ return ost; }

std::ostream & operator<<(std::ostream &ost, const Fragment &f)
{ return ost; }
