/*
 * writeDistanceEnergyTable.hpp
 *
 *  Created on: Nov 20, 2012
 *      Author: heber
 */

#ifndef WRITEDISTANCEENERGYTABLE_HPP_
#define WRITEDISTANCEENERGYTABLE_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>
#include <sstream>
#include <string>

namespace _detail {

  typedef std::vector<double> values_t;
  typedef std::vector< values_t > DistanceEnergyTable_t;

  /** Gets the number of column entries, i.e. number of rows.
   *
   * \note ASSERT's that all columns have equal number of entries
   *
   * @param table table to check
   * @return number of column entries
   */
  const size_t checkNumberOfColumnEntries(const DistanceEnergyTable_t &table)
  {
    size_t index = table[0].size();
    for (DistanceEnergyTable_t::const_iterator coliter = table.begin();
        coliter != table.end(); ++coliter)
      ASSERT( (*coliter).size() == index,
          "writeDistanceEnergyTable() - mismatch in column sizes.");
    return index;
  }

  /** Pretty prints the given distance-energy table.
   *
   * @param table table to print
   * @return string containing pretty-printed table
   */
  const std::string writeDistanceEnergyTable(const DistanceEnergyTable_t &table)
  {
    std::stringstream returnstream;

    if (table.size() > 0) {
      /// check each column for equal number of entries
      const size_t indices = checkNumberOfColumnEntries(table);

      /// print header line
      for (size_t index = 0; index < indices-1; ++index)
        returnstream << std::setprecision(10) << "distance" << index+1 << "\t";
      returnstream << std::setprecision(10) << "energy" << std::endl;

      /// print each row
      for (DistanceEnergyTable_t::const_iterator coliter = table.begin();
          coliter != table.end(); ++coliter) {
        for (DistanceEnergyTable_t::value_type::const_iterator rowiter = (*coliter).begin();
            rowiter != (*coliter).end(); ++rowiter) {
          returnstream << (*rowiter) << "\t";
        }
        returnstream << std::endl;
      }
    }

    return returnstream.str();
  }

}; /* namespace _detail */

#endif /* WRITEDISTANCEENERGYTABLE_HPP_ */
