/*
 * StockClient.hpp
 *
 *  Created on: Nov 18, 2011
 *      Author: heber
 */

#ifndef STOCKCLIENT_HPP_
#define STOCKCLIENT_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <boost/asio.hpp>
#include <vector>
#include "connection.hpp" // Must come before boost/serialization headers.
#include "FragmentJob.hpp"

/// Downloads stock quote information from a server.
class StockClient
{
public:
  /// Constructor starts the asynchronous connect operation.
  StockClient(boost::asio::io_service& io_service,
      const std::string& host, const std::string& service);

  /// Handle completion of a connect operation.
  void handle_connect(const boost::system::error_code& e);

  /// Handle completion of a read operation.
  void handle_read(const boost::system::error_code& e);

private:
  /// The connection to the server.
  connection connection_;

  /// The data received from the server.
  std::vector<FragmentJob> jobs_;
};

#endif /* STOCKCLIENT_HPP_ */
