/*
 * getFlatListFromHierarchyOfValidators.hpp
 *
 *  Created on: Sep 7, 2014
 *      Author: heber
 */

#ifndef GETFLATLISTFROMHIERARCHYOFVALIDATORS_HPP_
#define GETFLATLISTFROMHIERARCHYOFVALIDATORS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <algorithm>
#include <vector>

#include "Parameters/Validators/Validator.hpp"
#include "Parameters/Validators/Ops_Validator.hpp"

template <class T>
void ValidatorHierarchyClimber(
    const Validator<T> &_validator,
    std::vector<std::pair<const Validator<T> *, bool> > &_validators,
    const bool _groundtruth)
{
  if (dynamic_cast<const And_Validator<T> *>(&_validator) != NULL) {
    const And_Validator<T>& and_validator = dynamic_cast<const And_Validator<T>& >(_validator);
    ValidatorHierarchyClimber(*and_validator.getA(), _validators, _groundtruth);
    ValidatorHierarchyClimber(*and_validator.getB(), _validators, _groundtruth);
  } else if (dynamic_cast<const Or_Validator<T> *>(&_validator) != NULL) {
    const Or_Validator<T>& or_validator = dynamic_cast<const Or_Validator<T>& >(_validator);
    ValidatorHierarchyClimber(*or_validator.getA(), _validators, _groundtruth);
    ValidatorHierarchyClimber(*or_validator.getB(), _validators, _groundtruth);
  } else if (dynamic_cast<const Not_Validator<T> *>(&_validator) != NULL) {
    const Not_Validator<T>& not_validator = dynamic_cast<const Not_Validator<T>& >(_validator);
    ValidatorHierarchyClimber(*not_validator.getA(), _validators, !_groundtruth);
  } else if (dynamic_cast<const Validator<T> *>(&_validator) != NULL) {
    const Validator<T> * Tvalidator = dynamic_cast<const Validator<T> * >(&_validator);
    _validators.push_back( std::make_pair(Tvalidator, _groundtruth) );
  }
}

/** Function that recursively climbs down the hierarchy of validators and adds all
 * to a common vector as tuples of validator and a boolean, giving the ground truth
 * of the validator, i.e. whether it was negated by a prior Not_Validator.
 */
template <class T>
std::vector<std::pair<const Validator<T> *, bool> >
getFlatListFromHierarchyOfValidators(const Validator<T> &_validator)
{
  std::vector<std::pair<const Validator<T> *, bool> > validators;
  ValidatorHierarchyClimber(_validator, validators, true);
  return validators;
}


#endif /* GETFLATLISTFROMHIERARCHYOFVALIDATORS_HPP_ */
