/*
 * ParserFileValidator.hpp
 *
 *  Created on: May 9, 2012
 *      Author: heber
 */

#ifndef PARSERFILEVALIDATOR_HPP_
#define PARSERFILEVALIDATOR_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/filesystem.hpp>

#include "Parameters/Validators/Validator.hpp"

/** This validator checks whether the file via the given path has the suffix
 * of a valid \ref FormatParser type.
 */
class ParserFileValidator : public Validator< boost::filesystem::path >
{
  bool isValid(const boost::filesystem::path & _value) const;
  bool operator==(const Validator<boost::filesystem::path> &_instance) const;
  Validator< boost::filesystem::path >* clone() const;

public:
  std::vector<std::string> getSuffixes() const;
};


#endif /* PARSERFILEVALIDATOR_HPP_ */
