/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ParserFileValidator.cpp
 *
 *  Created on: May 14, 2012
 *      Author: ankele
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <string>
#include <boost/filesystem.hpp>
#include "ParserFileValidator.hpp"

#include "Parser/ParserTypes.hpp"
#include "Parser/FormatParserStorage.hpp"

bool ParserFileValidator::isValid(const boost::filesystem::path & _value) const
{
  for (ParserTypes t = ParserTypes_begin; t < ParserTypes_end; ++ t){
    const std::string dotted_suffix = std::string(".")+
        FormatParserStorage::getInstance().getSuffixFromType(t);
    //LOG(2, "DEBUG: ParserFileValidator compares " << _value.extension() << " with " << dotted_suffix << ".");
    if (_value.extension() == dotted_suffix)
      return true;
  }
  return false;
}

bool ParserFileValidator::operator==(const Validator<boost::filesystem::path> &_instance) const
{
  const ParserFileValidator *inst =
      dynamic_cast<const ParserFileValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< boost::filesystem::path >* ParserFileValidator::clone() const
{
  Validator< boost::filesystem::path > *inst =
      new ParserFileValidator();
  return inst;
}

std::vector<std::string> ParserFileValidator::getSuffixes() const
{
  std::vector<std::string> suffixes;
  for (ParserTypes t = ParserTypes_begin; t < ParserTypes_end; ++ t){
    suffixes.push_back(
        FormatParserStorage::getInstance().getSuffixFromType(t));
  }
  return suffixes;
}


