/*
 * FileSuffixValidator.hpp
 *
 *  Created on: May 10, 2012
 *      Author: heber
 */

#ifndef FILESUFFIXVALIDATOR_HPP_
#define FILESUFFIXVALIDATOR_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "Parameters/Validators/Validator.hpp"

/** This validator checks whether the given path contains a valid suffix of
 * a known \ref FormatParser.
 */
class FileSuffixValidator : public Validator< boost::filesystem::path >
{
public:
  FileSuffixValidator(const std::string &_suffix) :
    suffix(_suffix)
  {}

  bool isValid(const boost::filesystem::path & _value) const;
  bool operator==(const Validator<boost::filesystem::path> &_instance) const;
  Validator< boost::filesystem::path >* clone() const;

  const std::string & getSuffix() const
  { return suffix; }

private:
  std::string suffix;
};


#endif /* FILESUFFIXVALIDATOR_HPP_ */
