/*
 * Ops_Validator_impl.hpp
 *
 *  Created on: May 9, 2012
 *      Author: ankele
 */

#ifndef OPS_VALIDATOR_IMPL_HPP_
#define OPS_VALIDATOR_IMPL_HPP_



// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Validator.hpp"

/** Logical AND composition of two Validators.
 *
 */
template <class T>
class And_Validator : public Validator<T>
{
public:
  And_Validator(const Validator<T> &_a, const Validator<T> &_b) :
    a(_a.clone()), b(_b.clone())
  {}
  virtual ~And_Validator()
  {
    delete(a);
    delete(b);
  }

  bool isValid(const T & _value) const {
    return (*a)(_value) && (*b)(_value);
  }

  Validator<T>* clone() const
  { return new And_Validator(*a, *b);  }

  // comparator
  bool operator==(const Validator<T> &_instance) const
  {
    const And_Validator<T> *inst = dynamic_cast<const And_Validator<T> *>(&_instance);
    if (inst)
      return (*a == *inst->a) && (*b == *inst->b);
    return false;
  }

  Validator<T> *getA(){ return a; }
  Validator<T> *getB(){ return b; }
  const Validator<T> *getA() const { return a; }
  const Validator<T> *getB() const { return b; }

private:
  Validator<T> *a;
  Validator<T> *b;
};

/** Logical OR composition of two Validators.
 *
 */
template <class T>
class Or_Validator : public Validator<T>
{
public:
  Or_Validator(const Validator<T> &_a, const Validator<T> &_b) :
    a(_a.clone()), b(_b.clone())
  {}
  virtual ~Or_Validator()
  {
    delete(a);
    delete(b);
  }

  bool isValid(const T & _value) const {
    return (*a)(_value) || (*b)(_value);
  }

  Validator<T>* clone() const
  { return new Or_Validator(*a, *b);  }

  // comparator
  bool operator==(const Validator<T> &_instance) const
  {
    const Or_Validator<T> *inst = dynamic_cast<const Or_Validator<T> *>(&_instance);
    if (inst)
      return (*a == *inst->a) && (*b == *inst->b);
    return false;
  }

  Validator<T> *getA(){ return a; }
  Validator<T> *getB(){ return b; }
  const Validator<T> *getA() const { return a; }
  const Validator<T> *getB() const { return b; }

private:
  Validator<T> *a;
  Validator<T> *b;
};

/** Logical NOT composition of a Validator.
 *
 */
template <class T>
class Not_Validator : public Validator<T>
{
public:
  Not_Validator(const Validator<T> &_a) :
    a(_a.clone())
  {}
  virtual ~Not_Validator()
  {
    delete(a);
  }

  bool isValid(const T & _value) const {
    return !(*a)(_value);
  }

  Validator<T>* clone() const
  { return new Not_Validator(*a);  }

  // comparator
  bool operator==(const Validator<T> &_instance) const
  {
    const Not_Validator<T> *inst = dynamic_cast<const Not_Validator<T> *>(&_instance);
    if (inst)
      return (*a == *inst->a);
    return false;
  }

  Validator<T> *getA(){ return a; }
  const Validator<T> *getA() const { return a; }

private:
  Validator<T> *a;
};



template <class T>
And_Validator<T> operator&&(const Validator<T> &a, const Validator<T> &b)
{
  return And_Validator<T>(a, b);
}

template <class T>
Or_Validator<T> operator||(const Validator<T> &a, const Validator<T> &b)
{
  return Or_Validator<T>(a, b);
}

template <class T>
Not_Validator<T> operator!(const Validator<T> &a)
{
  return Not_Validator<T>(a);
}


#endif /* OPS_VALIDATOR_IMPL_HPP_ */
