/*
 * LineUnittest.hpp
 *
 *  Created on: May 27, 2010
 *      Author: crueger
 */

#ifndef LINEUNITTEST_HPP_
#define LINEUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

#include "LinearAlgebra/Line.hpp"

class LineUnittest : public CppUnit::TestFixture
{

  CPPUNIT_TEST_SUITE( LineUnittest) ;
  CPPUNIT_TEST ( constructionErrorTest );
  CPPUNIT_TEST ( constructionResultTest );
  CPPUNIT_TEST ( isContainedTest );
  CPPUNIT_TEST ( intersectionTest );
  CPPUNIT_TEST ( rotationTest );
  CPPUNIT_TEST ( sphereIntersectionTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void constructionErrorTest();
  void constructionResultTest();
  void isContainedTest();
  void intersectionTest();
  void rotationTest();
  void sphereIntersectionTest();

private:
  Line *la1;
  Line *la2;
  Line *la3;
  Line *lp1;
  Line *lp2;
  Line *lp3;

};

#endif /* LINEUNITTEST_HPP_ */
