/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * \file Server.cpp
 *
 * This file strongly follows the Serialization example from the boost::asio
 * library (see server.cpp)
 *
 *  Created on: Oct 21, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// boost asio needs specific operator new
#include <boost/asio.hpp>

#include "CodePatterns/MemDebug.hpp"

#include <boost/lexical_cast.hpp>
#include <iostream>

#include "atexit.hpp"
#include "CodePatterns/Info.hpp"
#include "FragmentScheduler.hpp"


int main(int argc, char* argv[])
{
  // from this moment on, we need to be sure to deinitialize in the correct order
  // this is handled by the cleanup function
  atexit(cleanUp);

  try
  {
    // Check command line arguments.
    if (argc != 2)
    {
      std::cerr << "Usage: " << argv[0] << " <port>" << std::endl;
      return 1;
    }
    unsigned short port = boost::lexical_cast<unsigned short>(argv[1]);
    std::cout << "Listening on port " << port << "." << std::endl;

    boost::asio::io_service io_service;
    FragmentScheduler Server(io_service, port);
    {
      Info info("io_service");
      io_service.run();
    }
  }
  catch (std::exception& e)
  {
    std::cerr << e.what() << std::endl;
  }

  return 0;
}
