/*
 * ActOnAllUnitTest.cpp
 *
 *  Created on: 04.10.2009
 *      Author: FrederikHeber
 */

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "../test/ActOnAlltest.hpp"
#include "ActOnAllUnitTest.hpp"
#include "memoryallocator.hpp"
#include "vector.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ActOnAllTest );


void ActOnAllTest::setUp()
{
  Vector *temp = NULL;
  // fill list with vectors
  temp = new Vector(1,0,0);
  VL.AddVector(temp);
  temp = new Vector(0,1,0);
  VL.AddVector(temp);
  temp = new Vector(0,0,1);
  VL.AddVector(temp);
  Ref = VL;
};


void ActOnAllTest::tearDown()
{
  VL.EmptyList();
  // Ref was copy constructed, hence has to be cleaned, too!
  Ref.EmptyList();
  MemoryUsageObserver::purgeInstance();
};

/** UnitTest for VectorList::ActOnAll() and Vector::AddVector(), Vector::SubtractVector(),
 */
void ActOnAllTest::AddSubtractTest()
{
  const Vector test(1.,0.,0.);

  // adding, subtracting
  VL.ActOnAll( &Vector::AddVector, &test );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , false );
  VL.ActOnAll( &Vector::SubtractVector, &test );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , true );
};

/** UnitTest for VectorList::ActOnAll()
 */
void ActOnAllTest::ScaleTest()
{
  double factor=2.;
  double inverse=1./2.;

  // scaling by value
  VL.ActOnAll( (void (Vector::*)(const double)) &Vector::Scale, 2. );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , false );

  VL.ActOnAll( (void (Vector::*)(const double)) &Vector::Scale, 0.5 );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , true );

  // scaling by ref
  VL.ActOnAll( (void (Vector::*)(const double * const)) &Vector::Scale, (const double * const)&factor );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , false );

  VL.ActOnAll( (void (Vector::*)(const double * const)) &Vector::Scale, (const double * const)&inverse );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , true );

  // scaling by three values
  double *factors = Malloc<double>(NDIM, "ActOnAllTest::ScaleTest - factors");
  double *inverses = Malloc<double>(NDIM, "ActOnAllTest::ScaleTest - inverses");
  for (int i=0;i<NDIM;++i) {
    factors[i] = 2.;
    inverses[i] = 1./factors[i];
  }
  VL.ActOnAll( (void (Vector::*)(const double ** const)) &Vector::Scale, (const double ** const)&factors );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , false );

  VL.ActOnAll( (void (Vector::*)(const double ** const)) &Vector::Scale, (const double ** const)&inverses );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , true );
  Free(factors);
  Free(inverses);
};

/** UnitTest for VectorList::ActOnAll() and Vector::MakeNormalVector()
 */
void ActOnAllTest::NormalizeTest()
{
  const Vector xaxis(1.,0.,0.);
  const Vector yaxis(0.,1.,0.);

  // normalize with respect to x and y axis
  bool (Vector::*f)(const Vector *, const Vector *) = &Vector::MakeNormalVector;
  VL.ActOnAll( f, &xaxis, &yaxis );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , false );

  // check that x and y components are zero
  for (ListOfVectors::iterator Runner = VL.Vectors.begin(); Runner != VL.Vectors.end(); Runner++) {
    CPPUNIT_ASSERT_EQUAL( (*Runner)->x[0] , 0. );
    CPPUNIT_ASSERT_EQUAL( (*Runner)->x[1] , 0. );
  }
};
