/*
 * UniqueFragments.hpp
 *
 *  Created on: Oct 18, 2011
 *      Author: heber
 */

#ifndef UNIQUEFRAGMENTS_HPP_
#define UNIQUEFRAGMENTS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <list>
#include <vector>

#include "graph.hpp"

class atom;
class bond;
class config;

/** Structure containing all values in power set combination generation.
 */
class UniqueFragments
{
public:
  UniqueFragments();
  ~UniqueFragments();

  typedef std::list<bond*> BondsPerSP;
  typedef std::vector< BondsPerSP > AllSPBonds;

  void InsertFragmentIntoGraph(); // Insert a KeySet into a Graph
  void InitialiseSPList(int Order);
  void FreeSPList(int Order);
  void SetSPList(int Order);
  void ResetSPList(int Order);
  void FillSPListandLabelVertices(int Order, KeySet &RestrictedKeySet);
  void OutputSPList(int Order);
  int CountNumbersInBondsList(int Order);
  void Init(atom *_Root, size_t AtomCount);
  void Cleanup();

  atom *Root;
  KeySet *FragmentSet;
  int FragmentCounter;
  int *BondsPerSPCount;
  double TEFactor;
  Graph *Leaflet;
  AllSPBonds BondsPerSPList;

private:
  config *configuration;
  int ANOVAOrder;
  int CurrentIndex;
  int *ShortestPathList;
  bool **UsedList;
};


#endif /* UNIQUEFRAGMENTS_HPP_ */
