/*
 * VectorSetUnitTest.hpp
 *
 *  Created on: Aug 17, 2009
 *      Author: heber
 */

#ifndef VECTORSETUNITTEST_HPP_
#define VECTORSETUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include <vector>

#include "Vector.hpp"

/********************************************** Test classes **************************************/

class VectorSetTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( VectorSetTest) ;
    CPPUNIT_TEST ( copyConstructorTest );
    CPPUNIT_TEST ( translateTest );
    CPPUNIT_TEST ( transformTest );
    CPPUNIT_TEST ( minDistanceTest );
    CPPUNIT_TEST ( minDistSquaredTest );
    CPPUNIT_TEST_SUITE_END();

public:
    void setUp();
    void tearDown();

    void copyConstructorTest();
    void translateTest();
    void transformTest();
    void minDistanceTest();
    void minDistSquaredTest();

private:
    std::vector<Vector> list;
};


#endif /* VECTORSETUNITTEST_HPP_ */
