/*
 * SubspaceFactorizerUnittest.hpp
 *
 *  Created on: Nov 13, 2010
 *      Author: heber
 */

#ifndef SUBSPACEFACTORIZERUNITTEST_HPP_
#define SUBSPACEFACTORIZERUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

typedef std::set<size_t> IndexSet;
typedef std::multimap< size_t, boost::shared_ptr<IndexSet> > IndexMap;
typedef std::list< boost::shared_ptr<VectorContent> > VectorList;
typedef std::list< std::pair<boost::shared_ptr<VectorContent>, double> > VectorValueList;
typedef std::vector< boost::shared_ptr<VectorContent> > VectorArray;
typedef std::vector< double > ValueArray;

class MatrixContent;

class SubspaceFactorizerUnittest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( SubspaceFactorizerUnittest) ;
  CPPUNIT_TEST ( BlockTest );
  CPPUNIT_TEST ( EigenvectorTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void BlockTest();
  void EigenvectorTest();

  enum { matrixdimension = 3 };
private:

  MatrixContent *matrix;

  MatrixContent ***transformation;
};

MatrixContent * getSubspaceMatrix(MatrixContent &bigmatrix, const IndexSet &rowindexset, const IndexSet &columnindexset);
void embedSubspaceMatrix(MatrixContent &bigmatrix, MatrixContent &subsystem, const IndexSet &rowindexset, const IndexSet &columnindexset);
std::ostream & operator<<(std::ostream &ost, const IndexSet &indexset);

#endif /* SUBSPACEFACTORIZERUNITTEST_HPP_ */
