/*
 * UIFactory.hpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#ifndef UIFACTORY_HPP_
#define UIFACTORY_HPP_

class Dialog;

class UIFactory
{

  enum InterfaceTypes {Text};
public:
  virtual ~UIFactory();

  // methods for creating UIElements
  virtual Dialog* makeDialog()=0;

protected:
  UIFactory();

// singleton stuff
public:
  static void makeUserInterface(InterfaceTypes type);
  static UIFactory* get();

private:
  static UIFactory *theFactory;
};

#endif /* UIFACTORY_HPP_ */
