/*
 * Dialog.hpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#ifndef DIALOG_HPP_
#define DIALOG_HPP_

#include<string>
#include<list>

class Dialog
{
public:
  Dialog();
  virtual ~Dialog();

  void queryInt(const char *, int *);
  void queryString(const char*, std::string *);

  virtual void display();

protected:
  virtual void handleInt(std::string,int *)=0;
  virtual void handleString(std::string,std::string *)=0;


private:
  // methodology for handling queries
  // all queries are stored and then performed at appropriate times

  //these queries can be handled by this dialog
  enum QueryType {Int,String};
  struct Query {
    std::string title;
    QueryType type;
    void *target;
  };

  std::list<Query> queries;

};

#endif /* DIALOG_HPP_ */
