/*
 * atom.hpp
 *
 *  Created on: Aug 3, 2009
 *      Author: heber
 */

#ifndef ATOM_HPP_
#define ATOM_HPP_

using namespace std;

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <iostream>

#include "element.hpp"
#include "tesselation.hpp"
#include "vector.hpp"

/** Single atom.
 * Class incorporates position, type
 */
class atom : public TesselPoint {
  public:
    Vector x;       //!< coordinate array of atom, giving position within cell
    Vector v;       //!< velocity array of atom
    element *type;  //!< pointing to element
    atom *previous; //!< previous atom in molecule list
    atom *next;     //!< next atom in molecule list
    atom *father;   //!< In many-body bond order fragmentations points to originating atom
    atom *Ancestor; //!< "Father" in Depth-First-Search
    //char *Name;      //!< unique name used during many-body bond-order fragmentation, comes from TesselPoint
    int FixedIon;   //!< config variable that states whether forces act on the ion or not
    int *sort;      //!< sort criteria
    //int nr;         //!< continuous, unique number, comes from TesselPoint
    int GraphNr;      //!< unique number, given in DepthFirstSearchAnalysis()
    int *ComponentNr;//!< belongs to this nonseparable components, given in DepthFirstSearchAnalysis() (if more than one, then is SeparationVertex)
    int LowpointNr; //!< needed in DepthFirstSearchAnalysis() to detect nonseparable components, is the lowest possible number of an atom to reach via tree edges only followed by at most one back edge.
    bool SeparationVertex; //!< whether this atom separates off subsets of atoms or not, determined in DepthFirstSearchAnalysis()
    bool IsCyclic;        //!< whether atom belong to as cycle or not, determined in DepthFirstSearchAnalysis()
    unsigned char AdaptiveOrder;  //!< current present bond order at site (0 means "not set")
    bool MaxOrder;  //!< whether this atom as a root in fragmentation still creates more fragments on higher orders or not

  atom();
  atom(class atom *pointer);
  ~atom();

  bool Output(int ElementNo, int AtomNo, ofstream *out, const char *comment = NULL) const;
  bool OutputXYZLine(ofstream *out) const;
  atom *GetTrueFather();
  bool Compare(const atom &ptr);

  private:
};

ostream & operator << (ostream &ost, const atom &a);

#endif /* ATOM_HPP_ */
