/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2015 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * NoDryRunAction.cpp
 *
 *  Created on: May 15, 2015
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "version.h"

#include <sstream>
#include <string>

#include "Actions/CommandAction/NoDryRunAction.hpp"

#include "Actions/ActionQueue.hpp"
#include "Actions/DryRunAdvocate.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "NoDryRunAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr CommandNoDryRunAction::performCall() {
  // set ActionQueue on to last element (hence skipping all in between)
  const bool oldstate = ActionQueue::getInstance().getDryRun();
  DryRunAdvocate::setDryRun(false);
  STATUS("Performing no more dry run from now on.");

  return ActionState::ptr(new CommandNoDryRunState(oldstate, params));
}

ActionState::ptr CommandNoDryRunAction::performUndo(ActionState::ptr _state) {
  CommandNoDryRunState *state = assert_cast<CommandNoDryRunState*>(_state.get());
  DryRunAdvocate::setDryRun(state->dryrunstate);
  {
    std::stringstream output;
    output << "Undoing unset dry run, is back to " << (state->dryrunstate ? "true" : "false");
    STATUS(output.str());
  }

  return ActionState::ptr(_state);
}

ActionState::ptr CommandNoDryRunAction::performRedo(ActionState::ptr _state){
  DryRunAdvocate::setDryRun(false);
  STATUS("Redoing unset dry run.");

  return ActionState::ptr(_state);
}

bool CommandNoDryRunAction::canUndo() {
  return true;
}

bool CommandNoDryRunAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
