/*
 * MpqcParser.hpp
 *
 *  Created on: 12.06.2010
 *      Author: heber
 */

#ifndef MPQCPARSER_HPP_
#define MPQCPARSER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "FormatParser.hpp"

#include <iosfwd>

/**
 * Loads a MPQC config file into the World and saves the World as a tremolo file.
 */
class MpqcParser : public FormatParser
{
public:

  enum Theory { CLHF, CLKS, MBPT2, MBPT2_R12, unknown };

  MpqcParser();
  ~MpqcParser();
  void load(std::istream* file);
  void save(std::ostream* file, const std::vector<atom *> &atoms);

  void setHessian(bool hessian);
  void setTheory(enum Theory _theory);

private:
  // whether output with computing hessian is desired.
  bool HessianPresent;
  enum Theory theory;

  void saveSimple(std::ostream *file, const std::vector<atom *> &atoms);
  void saveHessian(std::ostream *file, const std::vector<atom *> &atoms);
};

#endif /* MPQCPARSER_HPP_ */
