/*
 * GLWorldScene.hpp
 *
 *  This is based on the Qt3D example "teaservice", specifically parts of teaservice.cpp.
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLWORLDSCENE_HPP_
#define GLWORLDSCENE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qobject.h>

#include <iosfwd>

#include "Bond/bond.hpp"
#include "GLMoleculeObject_bond.hpp"
#include "GLMoleculeObject_molecule.hpp"
#include "types.hpp"

#include "UIElements/Qt4/InstanceBoard/QtObservedAtom.hpp"
#include "UIElements/Qt4/InstanceBoard/QtObservedBond.hpp"
#include "UIElements/Qt4/InstanceBoard/QtObservedMolecule.hpp"

class Shape;

class QGLPainter;
class QGLSceneNode;
class QGLView;

class GLMoleculeObject;
class GLMoleculeObject_atom;
class GLMoleculeObject_molecule;
class GLMoleculeObject_shape;

class QtObservedInstanceBoard;

/** This class contains a list of all molecules in the world.
 *
 */
class GLWorldScene : public QObject
{
  Q_OBJECT
public:
  GLWorldScene(
      QtObservedInstanceBoard * _board,
      QObject *parent=0);
  virtual ~GLWorldScene();

//#if !defined(QT_OPENGL_ES_1)
//  PerPixelEffect *lighting;
//#endif

  void changeMaterials(bool perPixel);
  QGLSceneNode* getAtom(size_t);
  QGLSceneNode* getMolecule(size_t);
  QGLSceneNode* getBond(size_t, size_t);

  void initialize(QGLView *view, QGLPainter *painter) const;
  void draw(QGLPainter *painter, const QVector4D &cameraPlane) const;

  enum SelectionModeType{
    SelectAtom,
    SelectMolecule
  };
  void setSelectionMode(SelectionModeType mode);

signals:
  void changed();
//  void updated();
  void changeOccured();
  void pressed();
  void released();
  void clicked();
  void clicked(atomId_t);
  void doubleClicked();
  void hoverChanged(const atomId_t);
  void hoverChanged(const moleculeId_t, int);

private slots:
  void atomClicked(atomId_t no);
  void atomRemoved(ObservedValue_Index_t _atomid);
  void atomInserted(QtObservedAtom::ptr);
  void bondRemoved(ObservedValue_Index_t _bondid);
  void bondInserted(QtObservedBond::ptr);
  void moleculeClicked(moleculeId_t no);
  void moleculeRemoved(ObservedValue_Index_t _molid);
  void moleculeInserted(QtObservedMolecule::ptr);
  void setSelectionModeAtom();
  void setSelectionModeMolecule();
  void addShape(const std::string &_name);
  void removeShape(const std::string &_name);
//  void update();
  void moleculesVisibilityChanged(ObservedValue_Index_t _id, bool _visible);
  void hoverChangedSignalled(GLMoleculeObject *ob);

public:
  void updateSelectedShapes();

private:

  //!> id of atom hovered over
  atomId_t hoverAtomId;

  typedef std::map< ObservedValue_Index_t , GLMoleculeObject_molecule* > MoleculeNodeMap;
  typedef std::map< ObservedValue_Index_t, GLMoleculeObject_atom* > AtomNodeMap;
  typedef std::map< ObservedValue_Index_t, GLMoleculeObject_bond* > BondNodeMap;
  typedef std::map< std::string , GLMoleculeObject_shape* > ShapeNodeMap;

  AtomNodeMap AtomsinSceneMap;
  BondNodeMap BondsinSceneMap;
  MoleculeNodeMap MoleculesinSceneMap;
  ShapeNodeMap ShapesinSceneMap;

  SelectionModeType selectionMode;

  QtObservedInstanceBoard * board;
};

#endif /* GLWORLDSCENE_HPP_ */
