/*
 * GLMoleculeObject_molecule.hpp
 *
 *  Created on: Mar 30, 2012
 *      Author: ankele
 */

#ifndef GLMOLECULEOBJECT_MOLECULE_HPP_
#define GLMOLECULEOBJECT_MOLECULE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLMoleculeObject.hpp"

#include <Qt3D/qgeometrydata.h>

#include "UIElements/Qt4/InstanceBoard/QtObservedMolecule.hpp"

#include <map>

#include <boost/function.hpp>

#include "GLMoleculeObject_bond.hpp"

#include "types.hpp"

class atom;
class bond;
class molecule;
class GLMoleculeObject_atom;
class GLWorldScene;
class QtObservedInstanceBoard;

class GLMoleculeObject_molecule : public GLMoleculeObject
{
  Q_OBJECT
public:
  GLMoleculeObject_molecule(
      QObject *parent,
      QtObservedMolecule::ptr &_ObservedMolecule);
  GLMoleculeObject_molecule(
      QGLSceneNode *mesh[],
      QObject *parent,
      QtObservedMolecule::ptr &_ObservedMolecule);
  virtual ~GLMoleculeObject_molecule();

  void initialize(QGLView *view, QGLPainter *painter);
  void draw(QGLPainter *painter, const QVector4D &cameraPlane);

  typedef std::pair< atomId_t, atomId_t> BondIds;
  friend std::ostream &operator<<(std::ostream &ost, const BondIds &t);

signals:
  void changed();
  void changeOccured();

private slots:
  //!> grant GLWorldScene access to private slots
  friend class GLWorldScene;

  void setVisible(bool value);

  void resetTesselationHull();
  void resetBoundingBox();
  void resetIndex(const moleculeId_t, const moleculeId_t);
  void resetSelected();

private:

  void init();

private:

  QGeometryData updateTesselationHull() const;

  //!> contains current version of the tesselation hull on request
  QGeometryData TesselationHull;


  atomId_t hoverAtomId;

  QtObservedMolecule::ptr ObservedMolecule;
};

std::ostream &operator<<(std::ostream &ost, const GLMoleculeObject_molecule::BondIds &t);


#endif /* GLMOLECULEOBJECT_MOLECULE_HPP_ */
