/*
 * DummyUI.hpp
 *
 *  Created on: Jul 29, 2010
 *      Author: crueger
 */

#ifndef DUMMYUI_HPP_
#define DUMMYUI_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Parameters/Parameter.hpp"
#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"

class DummyDialog : public Dialog
{
public:
  DummyDialog(){}
  virtual ~DummyDialog(){}

  virtual void queryEmpty(const char *, std::string = ""){}
  virtual void queryBoolean(Parameter<bool> &, const char *, std::string = ""){}
  virtual void queryInt(Parameter<int> &, const char *, std::string = ""){}
  virtual void queryInts(Parameter<std::vector<int> > &, const char *, std::string = ""){}
  virtual void queryUnsignedInt(Parameter<unsigned int> &, const char *, std::string = ""){}
  virtual void queryUnsignedInts(Parameter<std::vector<unsigned int> > &, const char *, std::string = ""){}
  virtual void queryString(Parameter<std::string> &, const char*, std::string = ""){}
  virtual void queryStrings(Parameter<std::vector<std::string> > &, const char*, std::string = ""){}
  virtual void queryDouble(Parameter<double> &, const char*, std::string = ""){}
  virtual void queryDoubles(Parameter<std::vector<double> > &, const char*, std::string = ""){}
  virtual void queryAtom(Parameter<const atom *> &, const char*,std::string = ""){}
  virtual void queryAtoms(Parameter<std::vector<const atom *> > &, const char*,std::string = ""){}
  virtual void queryMolecule(Parameter<const molecule *> &, const char*,std::string = ""){}
  virtual void queryMolecules(Parameter<std::vector<const molecule *> > &, const char*,std::string = ""){}
  virtual void queryVector(Parameter<Vector> &, const char*,bool, std::string = ""){}
  virtual void queryVectors(Parameter<std::vector<Vector> > &, const char*,bool, std::string = ""){}
  virtual void queryBox(Parameter<Box> &, const char*, std::string = ""){}
  virtual void queryElement(Parameter<const element *> &, const char*, std::string = ""){}
  virtual void queryElements(Parameter<std::vector<const element *> > &, const char*, std::string = ""){}
  virtual void queryFile(Parameter<boost::filesystem::path> &, const char*, std::string = ""){}
  virtual void queryRandomNumberDistribution_Parameters(Parameter<RandomNumberDistribution_Parameters> &, const char*, std::string = ""){}
};

class DummyUIFactory : public UIFactory
{
public:
  virtual ~DummyUIFactory(){}

  virtual Dialog* makeDialog(){return new DummyDialog;}
  virtual MainWindow* makeMainWindow(){return 0;}

  struct description : public UIFactory::factoryDescription {
    description():
        UIFactory::factoryDescription("Dummy")
    {}
    virtual ~description(){}

    virtual UIFactory* makeFactory(){return new DummyUIFactory;};
  };

protected:
  DummyUIFactory(){}
};

#endif /* DUMMYUI_HPP_ */
