/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotAtomByOrderAction.cpp
 *
 *  Created on: Mar 22, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Atom/atom.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Descriptors/AtomIdDescriptor.hpp"
#include "Descriptors/AtomOrderDescriptor.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "NotAtomByOrderAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "NotAtomByOrderAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotAtomByOrderAction::performCall() {
  const atom * Walker = World::getInstance().getAtom(AtomByOrder(params.order.get()));
  if (Walker != NULL) {
    if (World::getInstance().isSelected(Walker)) {
      LOG(1, "Unselecting atom " << *Walker);
      World::getInstance().unselectAtom(Walker);
      LOG(0, World::getInstance().countSelectedAtoms() << " atoms remain selected.");
      return Action::state_ptr(new SelectionNotAtomByOrderState(Walker->getId(), params));
    } else {
      return Action::success;
    }
  } else {
    return Action::failure;
  }
}

Action::state_ptr SelectionNotAtomByOrderAction::performUndo(Action::state_ptr _state) {
  SelectionNotAtomByOrderState *state = assert_cast<SelectionNotAtomByOrderState*>(_state.get());

  const atom * Walker = World::getInstance().getAtom(AtomById(state->WalkerId));
  World::getInstance().selectAtom(Walker);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotAtomByOrderAction::performRedo(Action::state_ptr _state){
  SelectionNotAtomByOrderState *state = assert_cast<SelectionNotAtomByOrderState*>(_state.get());

  const atom * Walker = World::getInstance().getAtom(AtomById(state->WalkerId));
  World::getInstance().unselectAtom(Walker);

  return Action::state_ptr(_state);
}

bool SelectionNotAtomByOrderAction::canUndo() {
  return true;
}

bool SelectionNotAtomByOrderAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
