/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotAtomByElementAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomSelectionDescriptor.hpp"
#include "Descriptors/AtomTypeDescriptor.hpp"
#include "Atom/atom.hpp"
#include "Element/element.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

#include "NotAtomByElementAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "NotAtomByElementAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotAtomByElementAction::performCall() {
  LOG(1, "Unselecting atoms of type " << *params.elemental.get());
  std::vector<atom *> unselectedAtoms = World::getInstance().getAllAtoms(!AtomsBySelection());
  World::getInstance().unselectAllAtoms(AtomByType(params.elemental.get()));
  LOG(0, World::getInstance().countSelectedAtoms() << " atoms remain selected.");
  return Action::state_ptr(new SelectionNotAtomByElementState(unselectedAtoms,params));
}

Action::state_ptr SelectionNotAtomByElementAction::performUndo(Action::state_ptr _state) {
  SelectionNotAtomByElementState *state = assert_cast<SelectionNotAtomByElementState*>(_state.get());

  World::getInstance().selectAllAtoms(AtomByType(state->params.elemental.get()));
  BOOST_FOREACH(atom *_atom, state->unselectedAtoms)
    World::getInstance().unselectAtom(_atom);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotAtomByElementAction::performRedo(Action::state_ptr _state){
  SelectionNotAtomByElementState *state = assert_cast<SelectionNotAtomByElementState*>(_state.get());

  World::getInstance().unselectAllAtoms(AtomByType(state->params.elemental.get()));

  return Action::state_ptr(_state);
}

bool SelectionNotAtomByElementAction::canUndo() {
  return true;
}

bool SelectionNotAtomByElementAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
