/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomByOrderAction.cpp
 *
 *  Created on: Mar 22, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Atom/atom.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"
#include "Descriptors/AtomIdDescriptor.hpp"
#include "Descriptors/AtomOrderDescriptor.hpp"

#include <iostream>
#include <string>

#include "AtomByOrderAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "AtomByOrderAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionAtomByOrderAction::performCall() {
  const atom *Walker = World::getInstance().getAtom(AtomByOrder(params.order.get()));
  if (Walker != NULL) {
    if (!World::getInstance().isSelected(Walker)) {
      LOG(1, "Selecting atom " << *Walker);
      World::getInstance().selectAtom(Walker);
      LOG(0, World::getInstance().countSelectedAtoms() << " atoms selected.");
      return Action::state_ptr(new SelectionAtomByOrderState(Walker->getId(), params));
    } else {
      return Action::success;
    }
  } else {
    return Action::failure;
  }
}

Action::state_ptr SelectionAtomByOrderAction::performUndo(Action::state_ptr _state) {
  SelectionAtomByOrderState *state = assert_cast<SelectionAtomByOrderState*>(_state.get());

  const atom *Walker = World::getInstance().getAtom(AtomById(state->WalkerId));
  World::getInstance().unselectAtom(Walker);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionAtomByOrderAction::performRedo(Action::state_ptr _state){
  SelectionAtomByOrderState *state = assert_cast<SelectionAtomByOrderState*>(_state.get());

  const atom *Walker = World::getInstance().getAtom(AtomById(state->WalkerId));
  World::getInstance().selectAtom(Walker);

  return Action::state_ptr(_state);
}

bool SelectionAtomByOrderAction::canUndo() {
  return true;
}

bool SelectionAtomByOrderAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
