/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomByElementAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomTypeDescriptor.hpp"
#include "Descriptors/AtomSelectionDescriptor.hpp"
#include "Atom/atom.hpp"
#include "Element/element.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

#include "AtomByElementAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "AtomByElementAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionAtomByElementAction::performCall() {
  LOG(1, "Selecting atoms of type " << *params.elemental.get());
  std::vector<atom *> selectedAtoms = World::getInstance().getAllAtoms(AtomsBySelection());
  World::getInstance().selectAllAtoms(AtomByType(params.elemental.get()));
  LOG(0, World::getInstance().countSelectedAtoms() << " atoms selected.");
  return Action::state_ptr(new SelectionAtomByElementState(selectedAtoms,params));
}

Action::state_ptr SelectionAtomByElementAction::performUndo(Action::state_ptr _state) {
  SelectionAtomByElementState *state = assert_cast<SelectionAtomByElementState*>(_state.get());

  World::getInstance().unselectAllAtoms(AtomByType(state->params.elemental.get()));
  BOOST_FOREACH(atom *_atom, state->selectedAtoms)
    World::getInstance().selectAtom(_atom);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionAtomByElementAction::performRedo(Action::state_ptr _state){
  SelectionAtomByElementState *state = assert_cast<SelectionAtomByElementState*>(_state.get());

  World::getInstance().selectAllAtoms(AtomByType(state->params.elemental.get()));

  return Action::state_ptr(_state);
}

bool SelectionAtomByElementAction::canUndo() {
  return true;
}

bool SelectionAtomByElementAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
