/*
 * BoostGraphHelpers.hpp
 *
 *  Created on: May 18, 2017
 *      Author: heber
 */


#ifndef GRAPH_BOOSTGRAPHHELPERS_HPP_
#define GRAPH_BOOSTGRAPHHELPERS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>

#include "types.hpp"

namespace BoostGraphHelpers {

  typedef std::vector<atomId_t> Nodeset_t;

#ifdef HAVE_INLINE
inline
#else
static
#endif
  bool isCommonNodeInVector(
      const Nodeset_t &_firstnodes,
      const Nodeset_t &_secondnodes) {
    // std::set_intersection builds full set in bad case: too much work, just
    // seek single element contained in either set
    Nodeset_t::const_iterator firstiter = _firstnodes.begin();
    Nodeset_t::const_iterator seconditer = _secondnodes.begin();
    while ((firstiter != _firstnodes.end()) && (seconditer != _secondnodes.end())) {
      if (*firstiter == *seconditer) {
        break;
      } else if (*firstiter > *seconditer) {
        ++seconditer;
      } else {
        ++firstiter;
      }
    }
    return ((firstiter != _firstnodes.end())
        && (seconditer != _secondnodes.end()));
  }
} /* namespace BoostGraphHelpers */


#endif /* GRAPH_BOOSTGRAPHHELPERS_HPP_ */
