/*
 * TextMenu.h
 *
 *  Created on: Dec 10, 2009
 *      Author: crueger
 */

#ifndef TEXTMENU_H_
#define TEXTMENU_H_

#include <list>
#include <ostream>
#include <string>

#include "Menu/Menu.hpp"
#include "defs.hpp"

class MenuItem;

/**
 * Used to produce any kind of text menu
 *
 * All Items are displayed and user is prompted for a key. The item corresponding to that key is then activated.
 */
class TextMenu : public Menu
{
public:
  TextMenu(ostream& _outputter, string _title, char _spacer=STD_MENU_TITLE_SPACER,int _length=STD_MENU_LENGTH);
  virtual ~TextMenu();

  virtual void addItem(MenuItem*);
  virtual void removeItem(MenuItem*);
  virtual void display();

  /**
   * Call doQuit if you want to return from this menu.
   */
  virtual void doQuit();
  /**
   * Check wether someone has chosen to quit
   */
  virtual bool hasQuit();

protected:
  virtual void showEntry(MenuItem*);

private:
  list<MenuItem*> items;
  ostream& outputter;
  string title;
  char spacer;
  int length;

  bool quit;
};

#endif /* TEXTMENU_H_ */
