/*
 * MenuItem.h
 *
 *  Created on: Dec 10, 2009
 *      Author: crueger
 */

#ifndef MENUITEM_H_
#define MENUITEM_H_

#include <string>

using namespace std;

class Menu;

/**
 * Base class for all kinds of MenuItems
 *
 * This class takes care of checking the triggers and performing appropriate actions.
 */
class MenuItem {
private:
  char trigger;
  string *description;
  bool added;

public:
  MenuItem(char,const char*,Menu*);
  virtual ~MenuItem();

  virtual void doTrigger()=0;
  virtual void checkTrigger(char);

  virtual const string formatEntry();

  virtual const string getDescription();
  char getTrigger();

  void add_to_menu(Menu*);
  bool wasAdded();

protected:
  void setDescription(string);
};

#endif /* MENUITEM_H_ */
