/*
 * MethodAction.h
 *
 *  Created on: Dec 11, 2009
 *      Author: crueger
 */

#ifndef METHODACTION_H_
#define METHODACTION_H_

#include <boost/function.hpp>

#include "Actions/Action.hpp"

/**
 * Wrapper class that allows the construction of Actions from any kind of Method
 */
class MethodAction : public Action
{
public:
  MethodAction(boost::function<void()>);
  virtual ~MethodAction();

  virtual void call();
  virtual void undo();
  virtual bool canUndo();

  boost::function<void()> executeMethod; //!< this stores the method to be called


};

#endif /* METHODACTION_H_ */
