/*
 * atom_trajectoryparticle.hpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

#ifndef ATOM_TRAJECTORYPARTICLE_HPP_
#define ATOM_TRAJECTORYPARTICLE_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fstream>

#include <gsl/gsl_randist.h>

#include "atom_atominfo.hpp"
#include "atom_particleinfo.hpp"
#include "atom_trajectoryparticleinfo.hpp"

/****************************************** forward declarations *****************************/

class atom;
class config;
class ForceMatrix;
class Vector;

/********************************************** declarations *******************************/


class TrajectoryParticle :  public TrajectoryParticleInfo, public virtual AtomInfo, public virtual ParticleInfo {
public:

  TrajectoryParticle();
  virtual ~TrajectoryParticle();

  // constraint potential and dynamics stuff
  void AddKineticToTemperature(double *temperature, int step) const;
  void EvaluateConstrainedForce(int startstep, int endstep, atom **PermutationMap, ForceMatrix *Force) const;
  void CorrectVelocity(double *ActualTemp, int Step, Vector *CoGVelocity);

  // trajectory stuff
  void ResizeTrajectory(int MaxSteps);
  void CopyStepOnStep(int dest, int src);
  void VelocityVerletUpdate(int MDSteps, config *configuration, ForceMatrix *Force, const size_t offset);
  void SumUpKineticEnergy( int Step, double *TotalMass, Vector *TotalVelocity ) const;

  // thermostats
  void Thermostat_Woodcock(double ScaleTempFactor, int Step, double *ekin);
  void Thermostat_Gaussian_init(int Step, double *G, double *E);
  void Thermostat_Gaussian_least_constraint(int Step, double G_over_E, double *ekin, config *configuration);
  void Thermostat_Langevin(int Step, gsl_rng * r, double *ekin, config *configuration);
  void Thermostat_Berendsen(int Step, double ScaleTempFactor, double *ekin, config *configuration);
  void Thermostat_NoseHoover_init(int Step, double *delta_alpha);
  void Thermostat_NoseHoover_scale(int Step, double *ekin, config *configuration);

private:

};


#endif /* ATOM_TRAJECTORYPARTICLE_HPP_ */
