/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ActionNameValidator.cpp
 *
 *  Created on: May 14, 2012
 *      Author: ankele
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "ActionNameValidator.hpp"

#include "Actions/ActionQueue.hpp"
#include "Actions/ActionRegistry.hpp"

bool ActionNameValidator::isValid(const std::string & _value) const
{
  if (MoleCuilder::ActionRegistry::getCompletely_instatiated())
    return MoleCuilder::ActionQueue::getInstance().isActionKnownByName(_value);
  else
    return false;
}

bool ActionNameValidator::operator==(const Validator<std::string> &_instance) const
{
  const ActionNameValidator *inst =
      dynamic_cast<const ActionNameValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< std::string >* ActionNameValidator::clone() const
{
  Validator< std::string > *inst =
      new ActionNameValidator();
  return inst;
}




