/*
 * StockServer.cpp
 *
 *  Created on: 18.11.2011
 *      Author: heber
 */

#include <boost/asio.hpp>
#include <boost/bind.hpp>
#include <boost/lexical_cast.hpp>
#include <iostream>
#include <vector>
#include "connection.hpp" // Must come before boost/serialization headers.
#include <boost/serialization/vector.hpp>
#include "stock.hpp"

#include "StockServer.hpp"

using namespace s11n_example;

StockServer::StockServer(boost::asio::io_service& io_service, unsigned short port) :
  acceptor_(io_service,
      boost::asio::ip::tcp::endpoint(boost::asio::ip::tcp::v4(), port)
  )
{
  // Create the data to be sent to each client.
  stock s;
  s.code = "ABC";
  s.name = "A Big Company";
  s.open_price = 4.56;
  s.high_price = 5.12;
  s.low_price = 4.33;
  s.last_price = 4.98;
  s.buy_price = 4.96;
  s.buy_quantity = 1000;
  s.sell_price = 4.99;
  s.sell_quantity = 2000;
  stocks_.push_back(s);
  s.code = "DEF";
  s.name = "Developer Entertainment Firm";
  s.open_price = 20.24;
  s.high_price = 22.88;
  s.low_price = 19.50;
  s.last_price = 19.76;
  s.buy_price = 19.72;
  s.buy_quantity = 34000;
  s.sell_price = 19.85;
  s.sell_quantity = 45000;
  stocks_.push_back(s);

  // Start an accept operation for a new connection.
  connection_ptr new_conn(new connection(acceptor_.get_io_service()));
  acceptor_.async_accept(new_conn->socket(),
    boost::bind(&StockServer::handle_accept, this,
      boost::asio::placeholders::error, new_conn));
}

void StockServer::handle_accept(const boost::system::error_code& e, connection_ptr conn)
{
  std::cout << "handle_accept called." << std::endl;
  if (!e)
  {
    // Successfully accepted a new connection. Send the list of stocks to the
    // client. The connection::async_write() function will automatically
    // serialize the data structure for us.
    conn->async_write(stocks_,
      boost::bind(&StockServer::handle_write, this,
      boost::asio::placeholders::error, conn));
}

  connection_ptr new_conn(new connection(acceptor_.get_io_service()));
  acceptor_.async_accept(new_conn->socket(),
    boost::bind(&StockServer::handle_accept, this,
      boost::asio::placeholders::error, new_conn));
}

void StockServer::handle_write(const boost::system::error_code& e, connection_ptr conn)
{
  // Nothing to do. The socket will be closed automatically when the last
  // reference to the connection object goes away.
}
