/*
 * ManyBodyPotential_TersoffUnitTest.hpp
 *
 *  Created on: Oct 04, 2012
 *      Author: heber
 */

#ifndef MANYBODYPOTENTIAL_TERSOFFUNITTEST_HPP_
#define MANYBODYPOTENTIAL_TERSOFFUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include <vector>

#include "LinearAlgebra/Vector.hpp"

#include "FunctionApproximation/FunctionModel.hpp"

class ManyBodyPotential_Tersoff;

/********************************************** Test classes **************************************/

class ManyBodyPotential_TersoffTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( ManyBodyPotential_TersoffTest) ;
    CPPUNIT_TEST ( operatorTest );
    CPPUNIT_TEST ( derivativeTest );
    CPPUNIT_TEST ( parameter_derivativeTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void operatorTest();
      void derivativeTest();
      void parameter_derivativeTest();

      typedef std::vector<Vector> configuration_t;
      typedef std::vector<configuration_t> configurations_t;
      static configurations_t configurations;
private:
      FunctionModel::parameters_t params;
      typedef std::vector<double> data_t;
      data_t output;
};

#endif /* MANYBODYPOTENTIAL_TERSOFFUNITTEST_HPP_ */
