/*
 * RotateAroundOriginByAngleAction.cpp
 *
 *  Created on: Aug 06, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/RotateAroundOriginByAngleAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "LinearAlgebra/Line.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "molecule.hpp"


#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

/****** MoleculeRotateAroundOriginByAngleAction *****/

// memento to remember the state when undoing

//class MoleculeRotateAroundOriginByAngleState : public ActionState {
//public:
//  MoleculeRotateAroundOriginByAngleState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeRotateAroundOriginByAngleAction::NAME[] = "rotate-origin";

MoleculeRotateAroundOriginByAngleAction::MoleculeRotateAroundOriginByAngleAction() :
  Action(NAME)
{}

MoleculeRotateAroundOriginByAngleAction::~MoleculeRotateAroundOriginByAngleAction()
{}

void MoleculeRotateAroundOriginByAngle(double angle) {
  ValueStorage::getInstance().setCurrentValue(MoleculeRotateAroundOriginByAngleAction::NAME, angle);
  ActionRegistry::getInstance().getActionByName(MoleculeRotateAroundOriginByAngleAction::NAME)->call(Action::NonInteractive);
};

Dialog* MoleculeRotateAroundOriginByAngleAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryDouble(NAME, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryVector("position", false, MapOfActions::getInstance().getDescription("position"));

  return dialog;
}

Action::state_ptr MoleculeRotateAroundOriginByAngleAction::performCall() {
  molecule *mol = NULL;
  double alpha = 0.;
  Vector Axis;

  // obtain axis to rotate to
  ValueStorage::getInstance().queryCurrentValue(NAME, alpha);
  ValueStorage::getInstance().queryCurrentValue("position", Axis);

  DoLog(0) && (Log() << Verbose(0) << "Rotate around origin by " << alpha << ", axis from origin to " << Axis << "." << endl);
  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;

    // Creation Line that is the rotation axis
    Line RotationAxis(Vector(0.,0.,0.), Axis);

    for (molecule::iterator iter = mol->begin(); iter != mol->end(); ++iter) {
      *((*iter)->node) = RotationAxis.rotateVector(*((*iter)->node), alpha);
    }
    DoLog(0) && (Log() << Verbose(0) << "done." << endl);
  }
  return Action::success;
}

Action::state_ptr MoleculeRotateAroundOriginByAngleAction::performUndo(Action::state_ptr _state) {
//  MoleculeRotateOriginState *state = assert_cast<MoleculeRotateOriginState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeRotateAroundOriginByAngleAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeRotateAroundOriginByAngleAction::canUndo() {
  return false;
}

bool MoleculeRotateAroundOriginByAngleAction::shouldUndo() {
  return false;
}

const string MoleculeRotateAroundOriginByAngleAction::getName() {
  return NAME;
}
