/*
 * ChangeTracker.cpp
 *
 *  Created on: Mar 1, 2010
 *      Author: metzler
 */

#include "Helpers/MemDebug.hpp"
#include "Parser/ChangeTracker.hpp"
#include "Patterns/Singleton_impl.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"

/**
 * Constructor. Signs on as an observer for the World.
 */
ChangeTracker::ChangeTracker() :
  Observable("ChangeTracker")
{
  isConsistent = true;
  World::getInstance().signOn(this);
}

/**
 * Destructor. Signs off from the World.
 */
ChangeTracker::~ChangeTracker() {
  World::getInstance().signOff(this);
}

/**
 * With this, the World can update the change tracker's state.
 */
void ChangeTracker::update(Observable *publisher) {
  isConsistent = false;
}

/**
 * Gets whether there are non-saved changes.
 *
 * \param true if there are any changes, false otherwise
 */
bool ChangeTracker::hasChanged() {
  return !isConsistent;
}

/**
 * Tells all observers (which are the different parsers) that they are supposed
 * to save the current state.
 */
void ChangeTracker::saveStatus() {
  DoLog(0) && (Log() << Verbose(0) << "Saving changes." << std::endl);
  if (hasChanged()) {
    notifyAll();
  }
}

CONSTRUCT_SINGLETON(ChangeTracker)
