/*
 * LinkedCell_Model_changeModel.hpp
 *
 *  Created on: Dec 20, 2011
 *      Author: heber
 */

#ifndef LINKEDCELL_MODEL_CHANGEMODEL_HPP_
#define LINKEDCELL_MODEL_CHANGEMODEL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/function.hpp>
#include <map>

#include "CodePatterns/Observer/Observable.hpp"

#include "LinkedCell_Model.hpp"
#include "LinkedCell_Model_Update.hpp"

class TesselPoint;

namespace LinkedCell {

  /** This structures encapsulates changes occuring to the model.
   *
   * We do this mostly to keep the Observer LinkedCell_Model away from the
   * Observable which we need for the Cacheable LinkedCell_Model::N.
   */
  class LinkedCell_Model::changeModel : public Observable {
  public:
    explicit changeModel(const double distance);
    ~changeModel();

    void addUpdate(
        const TesselPoint *Walker,
        const Update::PriorityLevel priority,
        boost::function<void (const TesselPoint *)> _updateMethod
        );
  protected:
    void performUpdates();
  private:
    typedef std::map<const TesselPoint *, Update*> UpdateQueueMap;
    UpdateQueueMap queue;
  };

} // namespace LinkedCell


#endif /* LINKEDCELL_MODEL_CHANGEMODEL_HPP_ */
