/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * LinkedCell_Model_changeModel.cpp
 *
 *  Created on: Dec 20, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "LinkedCell_Model_changeModel.hpp"

/** Constructor of LinkedCell_Model::changeModel.
 *
 */
LinkedCell::LinkedCell_Model::changeModel::changeModel(const double distance) :
    Observable(std::string("LinkedCell_Model("+toString(distance)+")::changeModel"))
{}

/** Destructor of LinkedCell_Model::changeModel.
 *
 */
LinkedCell::LinkedCell_Model::changeModel::~changeModel()
{
  // remove all remaining updates in the queue
  for (UpdateQueueMap::iterator iter = queue.begin();
      !queue.empty();
      iter = queue.begin()) {
    delete iter->second;
    queue.erase(iter);
  }
}

/** Adds an Update instance to the internal queue.
 *
 * @param Walker node which is the update object
 * @param _updateMethod bound function (to LinkedCell_Model instance) of the update function
 */
void LinkedCell::LinkedCell_Model::changeModel::addUpdate(
    const TesselPoint *Walker,
    const LinkedCell_Model::Update::PriorityLevel priority,
    boost::function<void (const TesselPoint *)> _updateMethod
    )
{
  UpdateQueueMap::iterator iter = queue.find(Walker);
  if (iter != queue.end()) {
    if(iter->second->getPriority() >= priority) {
      // replace present update with new one
      OBSERVE;
      delete iter->second;
      iter->second = new Update(_updateMethod, Walker, priority);
    }
  } else {
    // insert new update
    OBSERVE;
    queue.insert( std::make_pair(Walker, new Update(_updateMethod, Walker, priority)) );
  }
}

/** Empties changeModel::queue by performing all update functions.
 *
 */
void LinkedCell::LinkedCell_Model::changeModel::performUpdates()
{
  for (UpdateQueueMap::iterator iter = queue.begin();
      !queue.empty();
      iter = queue.begin()) {
    // perform update
    (*iter->second)();
    // remove update
    delete iter->second;
    queue.erase(iter);
  }
}
