/*
 * LinkedCell_Model_Update.hpp
 *
 *  Created on: Dec 20, 2011
 *      Author: heber
 */

#ifndef LINKEDCELL_MODEL_UPDATE_HPP_
#define LINKEDCELL_MODEL_UPDATE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/function.hpp>

#include "LinkedCell_Model.hpp"

class TesselPoint;

namespace LinkedCell {

  /** This class contains a specific update step for the LinkedCell_Model.
   *
   *  You have to implement the operator() function with the specific update
   *  functionality.
   */
  class LinkedCell_Model::Update {
  public:
    //!> PriorityLevel: The lower, the more it overrides others.
    typedef size_t PriorityLevel;

    Update(boost::function<void (const TesselPoint *)> _updateMethod, const TesselPoint *_Walker, const PriorityLevel _priority);
    ~Update();

    void operator()();

    size_t getPriority() const { return priority; }

  private:
    /** Hidden constructor of class Update.
     *
     * Prevent Update objects without objects to work on.
     */
    Update();

  private:
    //!> update method with bound subject
    boost::function<void (const TesselPoint *)> updateMethod;
    //!> update object
    const TesselPoint *Walker;
    //!> priority level of this Update (the lower, the more important)
    PriorityLevel priority;
  };
} // namespace LinkedCell

#endif /* LINKEDCELL_MODEL_UPDATE_HPP_ */
