/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * LinkedCell_Model_Update.cpp
 *
 *  Created on: Dec 20, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "LinkedCell_Model_Update.hpp"


/** Constructor for class Update.
 *
 * @param _updateMethod bound function with update method
 * @param _Walker node on which the update works
 * @param _priority priority of the update (the lower, the more important)
 */
LinkedCell::LinkedCell_Model::Update::Update(boost::function<void (const TesselPoint *)> _updateMethod, const TesselPoint *_Walker, const PriorityLevel _priority) :
  updateMethod(_updateMethod),
  Walker(_Walker),
  priority(_priority)
{}

/** Destructor of class Update.
 *
 */
LinkedCell::LinkedCell_Model::Update::~Update()
{}

/** The actual update operation working on \a Walker.
 *
 */
void LinkedCell::LinkedCell_Model::Update::operator()() {
  updateMethod(Walker);
}
