/*
 * Graph.hpp
 *
 *  Created on: Oct 20, 2011
 *      Author: heber
 */

#ifndef FRAGMENTATION_GRAPH_HPP_
#define FRAGMENTATION_GRAPH_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>
#include <string>

#include "Fragmentation/KeySet.hpp"

typedef std::pair<int, double> NumberValuePair;
typedef std::pair<KeySet, NumberValuePair> GraphPair;

class AdaptivityMap;

class Graph : public std::map <KeySet, NumberValuePair >
{
public:
  Graph();
  ~Graph();

  void InsertGraph(const Graph &graph, int &counter);

  bool ParseKeySetFile(const std::string &path);
  bool StoreKeySetFile(const std::string &path) const;
  bool ParseTEFactorsFile(char *path);
  bool StoreTEFactorsFile(char *path) const;

  AdaptivityMap * GraphToAdaptivityMap() const;
};

typedef std::pair<Graph::iterator, bool> GraphTestPair;

#endif /* FRAGMENTATION_GRAPH_HPP_ */
