/*
 * Fragmentation.hpp
 *
 *  Created on: Oct 18, 2011
 *      Author: heber
 */

#ifndef FRAGMENTATION_HPP_
#define FRAGMENTATION_HPP_


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Graph/DepthFirstSearchAnalysis.hpp"

#include "Fragmentation/fragmentation_helpers.hpp"
#include "Fragmentation/Graph.hpp"
#include "Fragmentation/HydrogenSaturation_enum.hpp"
#include "types.hpp"

#include <map>
#include <string>
#include <vector>

class atom;
class AtomMask_t;
class AdjacencyList;
class KeySet;
class molecule;

class Fragmentation
{
public:
  Fragmentation(molecule *_mol, AdjacencyList &_FileChecker, const enum HydrogenSaturation _saturation);
  ~Fragmentation();

  int FragmentMolecule(const std::vector<atomId_t> &atomids, int Order, const std::string &prefix, DepthFirstSearchAnalysis &DFS);

  const Graph& getGraph() const {
    return TotalGraph;
  }

private:

  void FragmentBOSSANOVA(molecule *mol, Graph &FragmentList, KeyStack &RootStack);
  int GuesstimateFragmentCount(int order);

  // order at site
  bool CheckOrderAtSite(AtomMask_t &AtomMask, const Graph &GlobalKeySetList, int Order, const std::string &path, bool LoopDoneAlready);
  bool StoreOrderAtSiteFile(const std::string &path);
  bool ParseOrderAtSiteFromFile(const std::vector<atomId_t> &atomids, const std::string &path);

  // storing fragments
  void FillRootStackForSubgraphs(KeyStack &RootStack, const AtomMask_t &AtomMask);
  bool AssignKeySetsToFragment(Graph &KeySetList, ListOfLocalAtoms_t &ListOfLocalAtoms, Graph &FragmentList, bool FreeList = false);
  void TranslateIndicesToGlobalIDs(Graph &FragmentList, int &TotalNumberOfKeySets, Graph &TotalGraph);

private:
  //!> pointer to molecule that is fragmented
  molecule *mol;
  //!> whether to saturate dangling bonds with hydrogen and hence treat hydrogen special
  const enum HydrogenSaturation saturation;
  //!> reference to an external adjacency for comparison
  AdjacencyList &FileChecker;
  //!> Resulting Graph with all keysets
  Graph TotalGraph;
};


#endif /* FRAGMENTATION_HPP_ */
